% This procedure creates figure 6

clear all

load ./mat_files/TD_to_fracking.mat

fracking_share_TD = mean(reshape(TD_.theta_f(1:40).*TD_.F_f(1:40)./TD_.o(1:40), 10,4))';
fracking_share_data = [0.05270527, 0.15020639, 0.17190603, 0.19508895]';


figure('color', 'w');
bar([fracking_share_data, fracking_share_TD]);
grid on
set(gca, 'fontsize', 20, 'fontweight', 'bold', 'fontname', 'palatino', 'xticklabels', {'2010s', '2020s', '2030s', '2040s'})
legend('Data', 'Model', 'location', 'northwest')
ylabel('Fracking market share', 'fontname', 'palatino')

print('../../Figures/Figure_6','-dpng')
